function parseUsername(url) {
  try {
    const parsed = new URL(url);
    if (parsed.hostname !== "www.tiktok.com") return "";
    const match = parsed.pathname.match(/^\/@([^/?#]+)/);
    return match ? match[1] : "";
  } catch {
    return "";
  }
}

const status = document.getElementById("status");
const exportBtn = document.getElementById("exportBtn");
const loginBtn = document.getElementById("loginBtn");

function openExportPanelOnTab(tabId) {
  chrome.tabs.sendMessage(tabId, { type: "OPEN_EXPORT_PANEL" }, (response) => {
    if (chrome.runtime.lastError || !response?.ok) {
      status.textContent = "Could not open export panel. Refresh TikTok page and try again.";
      return;
    }
    window.close();
  });
}

chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
  const activeTab = tabs[0];
  const username = activeTab?.url ? parseUsername(activeTab.url) : "";

  if (username) {
    status.textContent = `Ready for @${username}`;
    exportBtn.disabled = false;
    exportBtn.textContent = `Export @${username}`;
    exportBtn.addEventListener("click", () => {
      if (!activeTab?.id) {
        status.textContent = "Could not access the active tab.";
        return;
      }
      openExportPanelOnTab(activeTab.id);
    });
  } else {
    status.textContent = "Open a TikTok profile page to start export.";
    exportBtn.disabled = true;
  }
});

loginBtn.addEventListener("click", () => {
  chrome.runtime.sendMessage({ type: "OPEN_EXTRACTIK_LOGIN" });
});
