const DEFAULT_APP_BASE_URL = "https://www.extractik.com";
const input = document.getElementById("appBaseUrl");
const saveBtn = document.getElementById("saveBtn");
const saved = document.getElementById("saved");

chrome.storage.sync.get(["appBaseUrl"], (result) => {
  input.value = result.appBaseUrl || DEFAULT_APP_BASE_URL;
});

saveBtn.addEventListener("click", () => {
  const url = input.value.trim().replace(/\/$/, "");
  if (!url.startsWith("http://") && !url.startsWith("https://")) {
    saved.textContent = "Please enter a valid URL";
    return;
  }

  chrome.storage.sync.set({ appBaseUrl: url }, () => {
    saved.textContent = "Saved";
    setTimeout(() => {
      saved.textContent = "";
    }, 1500);
  });
});
